/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.sa;

import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.sa.AuthorizePanelBean;
import com.ibm.hwmca.p.sa.ServiceAgentUtils;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.HashMap;

public class AuthorizeTasklet
extends PanelTasklet {
    private static final String TRACE_MASKT = "ESA    T";
    private static final String TRACE_MASKF = "ESA    F";
    private static final String TRACE_MASKD = "ESA    D";
    private ServiceAgentUtils SAU;

    public AuthorizeTasklet() {
        Trace.trace(TRACE_MASKT, "<--> AuthorizeTasklet.init");
    }

    public void logException(Throwable throwable) {
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        AuthorizePanelBean myBean = new AuthorizePanelBean();
        if (request.isInitialRequest()) {
            int RSFSetting = ServiceAgentUtils.ESACheckRSF();
            if (RSFSetting == 1) {
                response.replace("com.ibm.hwmca.p.sa.res.ServiceAgent", "Authorize", myBean);
            } else {
                String messageID = RSFSetting == 2 ? "ESA00004" : (RSFSetting == 3 ? "ESA00005" : (RSFSetting == 4 ? "ESA00006" : "ESA00007"));
                this.showMessageBox(true, new LocalizableText("com.ibm.hwmca.p.sa.res.ServiceAgent", "ESA.title"), new MessageText("com.ibm.hwmca.p.sa.res.ServiceAgent", messageID), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{new LocalizableText("com.ibm.hwmca.p.sa.res.ServiceAgent", "Ok.button")});
                response.terminate();
            }
        } else if (request.isDisposed() || request.isCanceled()) {
            Trace.trace(TRACE_MASKF, "Terminating the task");
            response.terminate();
        } else {
            TaskActionEvent event = (TaskActionEvent)request.getData("event");
            myBean = (AuthorizePanelBean)request.getData("bean");
            String elementName = event.getElementName();
            if (elementName.equals("OKButton")) {
                Trace.trace(TRACE_MASKF, "OKButton PrimaryID[" + myBean.getPrimaryID() + "] OptionalID[" + myBean.getOptionalID() + "]");
                String PrimaryID = myBean.getPrimaryID();
                String OptionalID = myBean.getOptionalID();
                if (PrimaryID.equals("")) {
                    Trace.trace(TRACE_MASKF, "PrimaryID not set[" + PrimaryID + "]");
                    try {
                        this.showMessageBox(true, new LocalizableText("com.ibm.hwmca.p.sa.res.ServiceAgent", "ESA.title"), new MessageText("com.ibm.hwmca.p.sa.res.ServiceAgent", "ESA00001"), MsgType.ERROR_MESSAGE, new LocalizableText[]{new LocalizableText("com.ibm.hwmca.p.sa.res.ServiceAgent", "Ok.button")});
                    }
                    catch (TaskletException e) {
                        Trace.trace(TRACE_MASKF, "Exception Working with MessageBox");
                    }
                } else {
                    int rc;
                    HashMap<String, String> xmlParms = new HashMap<String, String>();
                    xmlParms.put("-PrimaryID", PrimaryID);
                    if (!OptionalID.equals("")) {
                        xmlParms.put("-OptionalID", OptionalID);
                    }
                    if ((rc = ServiceAgentUtils.ESASendAuthorizeRequest(2, xmlParms)) == 0) {
                        this.showMessageBox(true, new LocalizableText("com.ibm.hwmca.p.sa.res.ServiceAgent", "ESA.title"), new MessageText("com.ibm.hwmca.p.sa.res.ServiceAgent", "ESA00008"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{new LocalizableText("com.ibm.hwmca.p.sa.res.ServiceAgent", "Ok.button")});
                        myBean.setPrimaryID("");
                        myBean.setOptionalID("");
                    } else {
                        this.showMessageBox(true, new LocalizableText("com.ibm.hwmca.p.sa.res.ServiceAgent", "ESA.title"), new MessageText("com.ibm.hwmca.p.sa.res.ServiceAgent", "ESA00009"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{new LocalizableText("com.ibm.hwmca.p.sa.res.ServiceAgent", "Ok.button")});
                    }
                }
            } else if (elementName.equals("CancelButton")) {
                Trace.trace(TRACE_MASKF, "CancelButton");
            } else if (elementName.equals("HelpButton")) {
                Trace.trace(TRACE_MASKF, "HelpButton");
            } else {
                Trace.trace(TRACE_MASKF, "unknown");
            }
            response.update(myBean);
        }
    }

    public static void main(String[] args) {
        Object[] a = new String[]{"a", "b"};
        MessageText msg = new MessageText("com.ibm.hwmca.p.sa.res.ServiceAgent", "ESA00004", a);
        System.out.println(msg);
    }
}

